#!/bin/bash

if ! cat /proc/mounts | grep /mnt/usb > /dev/null 2>&1; then
    echo "USB memory device not connected"
    exit 1
fi

dataDir=opt/LanTEK/data
tmpDir=opt/LanTEK/tmp
logDir=$tmpDir/log
procDir=$tmpDir/proc
tempDir=$tmpDir/tmp


dataDirPath="/${dataDir}"
tmpDirPath="/${tmpDir}"
logDirPath="/${logDir}"
procDirPath="/${procDir}"
tempDirPath="/${tempDir}"

diagnosticsFileName=diagnostics_$(date +"%m%d%y_%H%M%S")
diagnosticsTarFilePath=$tmpDirPath/$diagnosticsFileName.tar

rm -f $tmpDirPath/diagnostics_*.tar.gz

if [ ! -d $logDirPath ]; then
    mkdir $logDirPath
fi

if [ -d $logDirPath ]; then
    cd $logDirPath
    cp /var/log/daemon.log* .
    tail -200000 /var/log/kern.log > kern.log
    ps aux > ps.log
    # collect CCMB logs
    scp -r -o ServerAliveInterval=4 -o ServerAliveCountMax=10 -o ConnectTimeout=2 -o TCPKeepAlive=yes root@192.168.9.2:/root/Log CCMB_Log
    scp -o ServerAliveInterval=4 -o ServerAliveCountMax=10 -o ConnectTimeout=2 -o TCPKeepAlive=yes root@192.168.9.2:/tmp/shelltest.log CCMB_Log
    #copy package update log as well
    cp /var/log/apt/term.log .
fi

if [ ! -d $procDirPath ]; then
    mkdir $procDirPath
fi

if [ -d $procDirPath ]; then
    cd $procDirPath
    rm -rf *
    cp /proc/meminfo .
    cp --parent /proc/*/maps .
fi

if [ ! -d $tempDirPath ]; then
    mkdir $tempDirPath
fi

if [ -d $tempDirPath ]; then
    cd $tempDirPath
    rm -rf *
    #copy only regular files from /tmp/
    for filename in $(ls /tmp); do
        filepath="/tmp/"${filename}
        [ -d ${filepath} ] && continue
        [ -f ${filepath} ] && cp ${filepath} .
    done
fi

cd /

filesList="${logDir}/ \
           ${procDir}/ \
           ${tempDir}/ \
           ${dataDir}/lantek.db \
           ${dataDir}/config.ini \
           ${dataDir}/results" \


for name in $filesList; do
    tar -rf $diagnosticsTarFilePath $name > /dev/null 2>&1
done

lastTestResultBlobPath="${tmpDir}/last_test_result.bin"
if [ -f ${lastTestResultBlobPath} ]; then
    tar -rf $diagnosticsTarFilePath $lastTestResultBlobPath > /dev/null 2>&1
fi

gzip $diagnosticsTarFilePath > /dev/null 2>&1

deviceFile=$(cat /proc/mounts | grep /mnt/usb | awk '{print $1}')
if [ "$deviceFile" == "" ]; then
    echo "USB memory device not connected"
    exit 1
else
    cp $diagnosticsTarFilePath.gz /mnt/usb/ > /dev/null 2>&1
    umount /mnt/usb  > /dev/null 2>&1
    mount $deviceFile /mnt/usb > /dev/null 2>&1
fi

rm -f $diagnosticsTarFilePath.gz
rm -rf ${logDirPath}/* ${procDirPath}/* ${tempDirPath}/*

echo "Copied $diagnosticsFileName.tar.gz to USB"

exit 0
